<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (isset($_GET['type']) && isset($_GET['input'])) {
    $type = $_GET['type'];
    $input = $_GET['input'];

    $url = "";

    // Determine the TikTok URL based on the requested type
    if ($type === 'followers') {
        $url = "https://www.tiktok.com/@$input";
    } elseif ($type === 'post_likes' || $type === 'post_views') {
        $url = $input; // Directly use the provided post URL
    } else {
        echo json_encode(["error" => "Invalid type specified. Valid types: followers, post_likes, post_views"]);
        exit;
    }

    // Set up cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo json_encode(["error" => "Error fetching TikTok data: " . curl_error($ch)]);
        curl_close($ch);
        exit;
    }
    curl_close($ch);

    // Parse response based on the requested type
    if ($response) {
        $result = "Not Found";

        if ($type === 'followers') {
            preg_match('/"followerCount":(\d+)/', $response, $matches);
            $result = isset($matches[1]) ? $matches[1] : $result;
            echo json_encode(["followers" => $result]);
        } elseif ($type === 'post_likes') {
            preg_match('/"diggCount":(\d+)/', $response, $matches);
            $result = isset($matches[1]) ? $matches[1] : $result;
            echo json_encode(["post_likes" => $result]);
        } elseif ($type === 'post_views') {
    if (strpos($url, '/photo/') !== false) {
        echo json_encode(["post_views" => "Photo / Not Found"]);
    } else {
        preg_match('/"playCount":(\d+)/', $response, $matches);
        $result = isset($matches[1]) ? $matches[1] : "Not Found";
        echo json_encode(["post_views" => $result]);
    }
}

    } else {
        echo json_encode(["error" => "Failed to fetch data from TikTok."]);
    }
} else {
    echo json_encode(["error" => "Invalid parameters. Provide 'type' (followers, post_likes, post_views) and 'input' (username or post URL)."]);
}
?>
