<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// === Your YouTube Data API Key ===
$apiKey = 'AIzaSyBsXCMbRkoAMR3imZZ_syEb_MOevTDtm2g';

// Check for required parameters
if (!isset($_GET['type']) || !isset($_GET['input'])) {
    echo json_encode(["error" => "Invalid parameters. Provide 'type' (views, likes, comments) and 'input' (video URL)."]);
    exit;
}

$type = $_GET['type'];
$input = $_GET['input'];

// Extract video ID
function extractYouTubeVideoId($url) {
    $patterns = array(
        '/youtube\.com\/watch\?v=([^&]+)/',
        '/youtu\.be\/([^?&]+)/',
        '/youtube\.com\/embed\/([^?&]+)/',
        '/youtube\.com\/v\/([^?&]+)/'
    );

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $url, $match)) {
            return $match[1];
        }
    }
    return false;
}

// Get video statistics from YouTube API
function getYouTubeVideoStats($videoId, $apiKey) {
    $apiUrl = 'https://www.googleapis.com/youtube/v3/videos?id=' . $videoId . '&key=' . $apiKey . '&part=statistics';
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    if (isset($data['items'][0]['statistics'])) {
        return $data['items'][0]['statistics'];
    }
    return [];
}

// Main logic
$videoId = extractYouTubeVideoId($input);
if (!$videoId) {
    echo json_encode(["error" => "Invalid YouTube video URL."]);
    exit;
}

$stats = getYouTubeVideoStats($videoId, $apiKey);

// Return specific stat based on 'type'
switch ($type) {
    case 'views':
        echo json_encode(["views" => $stats['viewCount'] ?? "Not Found"]);
        break;
    case 'likes':
        echo json_encode(["likes" => $stats['likeCount'] ?? "Not Found"]);
        break;
    case 'comments':
        echo json_encode(["comments" => $stats['commentCount'] ?? "Not Found"]);
        break;
    default:
        echo json_encode(["error" => "Invalid type. Use: views, likes, comments"]);
        break;
}
?>